/**
 * 
 */
package com.ejie.ab18a.security;

import java.util.Vector;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

import com.ejie.ab18a.utils.Ab18aAccesoWS;
import com.ejie.ab18a.utils.Ab18aConvertirJaxb;
import com.ejie.ab18a.utils.Utilidades;
import com.ejie.x38.security.Credentials;
import com.ejie.x38.security.MyAuthenticatedUserDetailsService;
import com.ejie.x38.security.MyUserDetails;
import com.ejie.x38.security.PerimetralSecurityWrapper;
import com.ejie.x38.security.XlnetGrantedAuthority;
import com.ejie.xmlbeans.ServicioObtencionPerfilesUsuarios;
import com.ejie.xmlbeans.TipoPerfil;

/**
 * @author XXXX
 * 
 */
public class Ab18aAuthenticatedUserDetailsService implements AuthenticationUserDetailsService<Authentication> {
	private static final Logger logger = LoggerFactory.getLogger(MyAuthenticatedUserDetailsService.class);
	private PerimetralSecurityWrapper perimetralSecurityWrapper;

	public UserDetails loadUserDetails(Authentication token) throws UsernameNotFoundException {
		Assert.notNull(token.getCredentials());
		logger.trace("User's token is: " + token.toString());
		logger.trace("User's credentials are " + token.getCredentials().toString());

		Credentials credentials = (Credentials) token.getCredentials();
		UserDetails userDetails = null;
		if (credentials != null && StringUtils.isNotBlank(credentials.getNif())) {
			Vector<String> vectorProfilesXLNET = credentials.getUserProfiles();
			XlnetGrantedAuthority[] profiles = null;
			if (vectorProfilesXLNET != null) {

				int contadorAuthXLNET = 0;
				String dniUsuarioLogeado = Utilidades.calculoLetraDNI(credentials.getNif());
				ServicioObtencionPerfilesUsuarios perfil = null;
				try {
					String[] params = { "dni" };
					String[] values = { dniUsuarioLogeado };

					String resultado = Ab18aAccesoWS.obtenerInformacionWS("obtenerPerfilesUsuariosOSBUS", params, values);

					Ab18aConvertirJaxb conversion = new Ab18aConvertirJaxb();

					if (resultado != null) {
						perfil = conversion.xmlToPerfiles(resultado);
					}

					if (Utilidades.notNullAndNotEmpty(perfil) && Utilidades.notNullAndNotZero(perfil.getIdUsuario())) {
						profiles = new XlnetGrantedAuthority[perfil.getPerfiles().getPerfil().size()];

						for (TipoPerfil perfilAux : perfil.getPerfiles().getPerfil()) {
							String authority = "ROLE_" + perfilAux.getCodigoPerfil();
							logger.debug("Creado el rol " + authority + " - " + perfilAux.getDescPerfilCast());
							profiles[contadorAuthXLNET] = new XlnetGrantedAuthority(authority);
							contadorAuthXLNET++;
						}
					} else {
						throw new AccessDeniedException("");
						// profiles = new
						// XlnetGrantedAuthority[vectorProfilesXLNET.size()];
					}
				} catch (Exception e) {
					logger.error("Error al obtener el usuario Ab18aAuthenticatedUserDetailsService:\t" + e.getMessage());
					credentials.setDestroySessionSecuritySystem(true);
					throw new AccessDeniedException("");
				}
			}
			userDetails = this.createuserDetails(token, profiles);
		}
		logger.trace("UserDetails is: " + userDetails.toString());

		return userDetails;
	}

	protected MyUserDetails createuserDetails(Authentication token, GrantedAuthority[] profiles) {
		return new MyUserDetails(token.getName(), "N/A", true, true, true, true, profiles);
	}

	public PerimetralSecurityWrapper getPerimetralSecurityWrapper() {
		return this.perimetralSecurityWrapper;
	}

	public void setPerimetralSecurityWrapper(PerimetralSecurityWrapper perimetralSecurityWrapper) {
		this.perimetralSecurityWrapper = perimetralSecurityWrapper;
	}
}
